---
generated_at: 2026-01-27 12:55:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-npm run test-e2e.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数（約300-400 examples）**：実際のexample数との整合性要確認
  2. **目標処理時間30分**：CI設定からの推測であり実測値ではない
  3. **メモリ使用量上限**：具体的な制限値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scripts.test-e2e定義
- E-02: `test/e2e/puppeteer.js` - メイン処理実装
- E-03: `.github/workflows/ci.yml` - CIジョブ定義
- E-04: `test/e2e/deterministic-injection.js` - 決定論的テスト用スクリプト
- E-05: `test/e2e/clean-page.js` - ページクリーンアップスクリプト
- E-06: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは`node test/e2e/puppeteer.js`を実行 | E-01 | ○ |
| C-02 | ポート1234でサーバー起動 | E-02 (line 95) | ○ |
| C-03 | pixelThreshold=0.1（1ピクセルの許容誤差） | E-02 (line 96) | ○ |
| C-04 | maxDifferentPixels=0.3%（差分許容率） | E-02 (line 97) | ○ |
| C-05 | idleTime=2秒（ネットワークアイドル判定） | E-02 (line 99) | ○ |
| C-06 | networkTimeout=5分 | E-02 (line 102) | ○ |
| C-07 | renderTimeout=5秒 | E-02 (line 103) | ○ |
| C-08 | numAttempts=2（リトライ回数） | E-02 (line 104) | ○ |
| C-09 | numCIJobs=5（CI並列数） | E-02 (line 105) | ○ |
| C-10 | スクリーンショットサイズ400x250、viewScale=2 | E-02 (lines 107-109) | ○ |
| C-11 | SwiftShaderを使用 | E-02 (line 221-222) | ○ |
| C-12 | CI環境変数でファイルを分割 | E-02 (lines 206-215) | ○ |
| C-13 | 例外リストに約60件のexample | E-02 (lines 8-91) | ○ |
| C-14 | Math.random、Date.now、performance.nowを固定値化 | E-04 | ○ |
| C-15 | GUIとStats.jsを非表示化 | E-05 | ○ |
| C-16 | CI timeout-minutes: 30 | E-03 (line 43) | ○ |
| C-17 | ubuntu-latestで実行 | E-03 (line 42) | ○ |
| C-18 | Node.js 24を使用 | E-03 (line 57) | ○ |
| C-19 | 出力先はtest/e2e/output-screenshots/ | E-02 (line 147) | ○ |
| C-20 | build/three.core.js等を読み込み | E-02 (lines 244-248) | ○ |
| C-21 | JPG品質95% | E-02 (line 110) | ○ |
| C-22 | --webgpuフラグでWebGPUのみ対象 | E-02 (lines 164-167, 202) | ○ |
| C-23 | --makeフラグでスクリーンショット生成モード | E-02 (lines 171-176) | ○ |
| C-24 | 失敗時に差分画像を3種類出力 | E-02 (lines 546-548) | ○ |
| C-25 | 想定処理件数300-400 examples | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実際のexamples数は動的に変化するため、正確な件数は実行時にのみ確定
  - 候補：examples/ディレクトリの直接確認 / CI実行ログの参照 / files.jsonの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理パラメータはソースコードから正確に抽出
- 0: 低リスク - CIジョブの設定値は.github/workflows/ci.ymlと整合
- 1: 中リスク - example数の推定値は変動可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 例外リストの内容が最新のexceptionListと一致しているか確認
- [ ] CI環境での実際の実行時間が30分以内に収まっているか確認
- [ ] 新規追加されたexampleがテスト対象に含まれているか確認
